
#ifndef TZMATHS_H
#define	TZMATHS_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  unsigned long flag;
  unsigned char start_month;  // 1-12
  signed char start_week;     // 1 = first, 2 = second, -1 = last, -2 = second-last, etc.
  unsigned char start_dow;    // 0-6, 0 = Sunday
  signed char start_hour;     // non-DST hour, can be negative if changeover occurs the day before
  unsigned char finish_month; // 1-12
  signed char finish_week;    // 1 = first, 2 = second, -1 = last, -2 = second-last, etc.
  unsigned char finish_dow;   // 0-6, 0 = Sunday
  signed char finish_hour;    // non-DST hour, can be negative if changeover occurs the day before
} daylight_savings_info;
            
#define DAY_SUN         0
#define DAY_MON         1
#define DAY_FRI         5
#define DAY_SAT         6
#define WEEK_1ST        1
#define WEEK_2ND        2
#define WEEK_3RD        3
#define WEEK_4TH        4
#define WEEK_LAST      -1
#define WEEK_EQUI       0
#define EXCEPT_RAMADAN  1
#define EXCEPT_CARNAVAL 2
#define EXCEPT_ROSH_HAS 4
#define DST_FLAG_TYPE_MASK (~(EXCEPT_RAMADAN|EXCEPT_CARNAVAL|EXCEPT_ROSH_HAS))

extern const daylight_savings_info daylight_savings[19];

// Main timezone functions
__attribute__((mips16)) unsigned char apply_timezone(int* time, int* date, int tz, const signed long* tzinfo, const daylight_savings_info* dstinfo);
__attribute__((mips16)) unsigned char unapply_timezone(int* time, int* date, int tz, const signed long* tzinfo, const daylight_savings_info* dstinfo);
__attribute__((mips16)) void add_timezone_offset(int* time, int* date, int offset);

// Helper functions which may come in handy
__attribute__((mips16)) void add_sub_days(unsigned char* day, unsigned char* month, unsigned char* year, int num_days);
__attribute__((mips16)) void unpack_dst_info(daylight_savings_info* tohere, unsigned int packed);
__attribute__((mips16)) unsigned int pack_dst_info(const daylight_savings_info* fromhere);
__attribute__((mips16)) unsigned int reverse_tz_map(int timezone);

#ifdef __cplusplus
}
#endif

#endif	/* TZMATHS_H */

